% ios.cls
%
% LaTeX 2e style class for IOS Press publications style (unofficial)
% Conversion of ioscrc.sty by Dave Beckett, D.J.Beckett@ukc.ac.uk
% 20th Feburary 1998
%
% Based on the article style with A4 paper, 12pt, twoside, one column and
% no title page.
%
% INSTRUCTIONS:
%
% \documentclass{ios}
%
% % other packages can be loaded here e.g:
% \usepackage{epsfig}
%
% DO NOT USE OPTIONS/PACKAGES SUCH AS 12pt, a4paper, twoside, times
% or alter the margins.
%
% \begin{document}
%
% \title{The Long Title of Your Paper}
% \author{A.B. Author and C.D. Author\\
%        {\small\itshape Authors Institution, Address, Country}}
% \ioshead{A.B. Author and C.D. Author}{Short Title of Paper}
% \iosdetails{Title of Proceedings}{Journal Editors}{Year}
% \maketitle
%
% \begin{abstract}
%   The abstract...
% \end{abstract}
%
% ... rest of paper ...
%
% \end{document}
%
% Original comment on old file (every line changed basically)
%
% ioscrc.sty made by Diamant & Hol Publishers, copyright october 1997
% based on article.sty 16-Mar-88
% last edited on: 11/11/97
%

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{ios}[1998/02/20 v1.5 IOS Press Style (2e conversion)]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[12pt,twoside,onecolumn,draft]{article}

\usepackage{times}

% Changes to font sizes - 12pt (size12.clo) is ok
% change normalsize to be 12pt+4pt line spacing
\renewcommand\normalsize{%
   \@setfontsize\normalsize{12}{14pt}% IOS change: was \@xiipt{13.6}
   \abovedisplayskip 12\p@ \@plus3\p@ \@minus7\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
% change small to be 10pt+2pt line spacing
\renewcommand\small{%
   \@setfontsize\small{10}{12pt} % IOS change: was \@xipt{13.6}
   % These 4 commands set math style font parameters
   \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \def\@listi{\leftmargin\leftmargini
               \topsep 9\p@ \@plus3\p@ \@minus5\p@
               \parsep 4.5\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
}
% Another change; footnote=small font
\let\footnotesize=\small
% huge font for title is now 24pt+4pt (note here \Huge=\huge)
\renewcommand\huge{\@setfontsize\huge{24}{28pt}}

% Change text area size
%breedte exact 15.6 cm, Diamant & Hol Publishers
\setlength{\textwidth}{156mm}
\@settopoint\textwidth
\setlength\textheight{250mm}

% The size of the margin from the top of the page head
\setlength\topmargin{-12mm}

\setlength\marginparwidth{68pt}
\setlength\oddsidemargin{39.5pt}
\setlength\evensidemargin{39.5pt}
\@settopoint\marginparwidth
\@settopoint\oddsidemargin
\@settopoint\marginparwidth

% continuation of article.cls style code

% Horizontal offset of the output page from the printer border set by
% the printer driver.  The printer border is normally 1inch from the
% left edge of the paper.  \hoffset is normally 0 so left margin of
% page is identical to printer margin.
\setlength\hoffset{-14truemm}


% Headings - always twosided
\def\@headauthors{Authors}
\def\@headtitle{Short Title}
\newcommand{\ioshead}[2]{%
  \gdef\@headauthors{#1}
  \gdef\@headtitle{#2}
  }  
\newcommand{\@ioshead}{{\slshape\@headauthors\ /\ \@headtitle}}

\def\ps@myheadings{%
    \def\@oddhead{\small\hbox{}\hfil\@ioshead\hfil\thepage}
    \def\@evenhead{\small\thepage\hfil\@ioshead\hfil\hbox{}}
    \def\@oddfoot{}
    \def\@evenfoot{}
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }

\def\@iosbookname{Book Title}
\def\@ioseditors{Editors}
\def\@iosyear{\year}
\newcommand{\iosdetails}[3]{%
  \gdef\@iosbookname{#1}
  \gdef\@ioseditors{#2}
  \gdef\@iosyear{#3}
  }  
\newcommand{\@iosdetails}{%
  \begin{minipage}[t]{12cm}\slshape
    \@iosbookname\\
    \@ioseditors\, (Eds.)\\
    IOS Press, \@iosyear
  \end{minipage}}

\def\ps@firstpage{%
    \def\@oddhead{\small\@iosdetails\hfil\thepage}
    \def\@evenhead{\small\thepage\hfil\@iosdetails}
    \def\@oddfoot{}
    \def\@evenfoot{}
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }

\pagestyle{myheadings}


% Never have titlepage
\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\fnsymbol{footnote}}%
    \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
    \newpage
    \global\@topnum\z@   % Prevents figures from going at top of page.
    \@maketitle
    \thispagestyle{firstpage}\@thanks % IOS change: pagestyle was empty
  \endgroup
  \setcounter{footnote}{0}
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}
    {\LARGE \bf \@title \par}%
    \vskip 1.5em%
    {\normalsize% IOS change
      \lineskip .5em
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
  \end{center}
  \par
  %\vskip 4mm
}


% Slight IOS changes in font series, styles and sizes
% I don't know what \goodbreak does
\renewcommand\section{\goodbreak\vskip4mm \@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\reset@font\normalsize\bfseries}} % IOS change - normalsize
\renewcommand\subsection{\goodbreak\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {2.3ex \@plus .2ex}%
                                     {\reset@font\normalsize\slshape}} % IOS change - normalsize,italic
\renewcommand\subsubsection{\goodbreak\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\reset@font\normalsize\slshape}} % IOS change - italic
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\reset@font\normalsize\slshape}} % IOS change - italic
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\reset@font\normalsize\slshape}} % IOS change - italic


% IOS Abstract environment
\renewenvironment{abstract}{%
    \small
    \quotation
    \parshape=1 18mm 120mm
    \noindent{\bf Abstract.}}
   {\endquotation}


% redefinitions to get ios tables and captions
\setlength\belowcaptionskip{2pt}

% FROM ltfloat.dtx
%    \@makecaption{NUM}{TEXT} : A macro to make a caption, with NUM the value
%                  produced by \fnum@... and TEXT the text of the caption.
%                  It can assume it's in a \parbox of the appropriate width.

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small #1: #2}% IOS change: \small
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\def\@caption#1[#2]#3{%
  \par
  \addcontentsline {\csname ext@#1\endcsname}{#1}%
    {\protect\numberline{\csname the#1\endcsname }{\ignorespaces #2}}%
  \begingroup
    \@parboxrestore
    \if@minipage
      \@setminipage
    \fi
    \small % IOS change: \small
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

% I think IOS wants tables in small font
\renewenvironment{table}{\small \@float{table}}{\end@float}
\renewenvironment{table*}{\small \@dblfloat{table}}{\end@dblfloat}

% Not defined in article style, this version taken from book style
\newcommand\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\endinput
